function GetObjects( objectpicker, allownothing, eventhandler )
{
	while ( 1 )
	{
		if ( !objectpicker.waitForEvent() )
			return false;
			
		if ( objectpicker.event == 'finished' )
		{
			break;
		}
		else if ( objectpicker.event == 'done' )
		{
			// If we are successfully done, or if we are allowing nothing, then
			// break out and return true.
			if ( objectpicker.done() || allownothing )
				break;
				
			// Otherwise, the user pushed done, but we don't have the right input yet.
			// Return false to bail out.
			return false;
		}
		
		if ( eventhandler && eventhandler( objectpicker ) )
			break;
	}
	
	objectpicker.objects.lockSelection();
	
	return true;
}
